SWEP.Category 				= "Kingpin"
SWEP.PrintName				= "Crowbar"
SWEP.ViewModelFOV			= 90
SWEP.Spawnable 				= true
SWEP.AdminOnly 				= false
SWEP.Base					= "kingpin_base"

SWEP.Primary.Sound			= Sound("weapons/v_pipebar/swing.wav")
SWEP.Primary.ClipSize		= -1
SWEP.Primary.DefaultClip	= -1
SWEP.Primary.Delay			= 1
SWEP.Primary.Automatic		= true
SWEP.Primary.Ammo			= "None"

SWEP.Secondary.ClipSize		= -1
SWEP.Secondary.DefaultClip	= -1
SWEP.Secondary.Automatic	= false
SWEP.Secondary.Ammo			= "None"
SWEP.BobScale				= 0.5
SWEP.SwayScale				= 0.1
SWEP.Weight					= 3
SWEP.AutoSwitchTo			= false
SWEP.AutoSwitchFrom			= false
SWEP.Slot					= 0
SWEP.SlotPos				= 4
SWEP.DrawAmmo				= false
SWEP.DrawCrosshair			= false

SWEP.ViewModel				= "models/weapons/v_crowk.mdl"
SWEP.WorldModel				= "models/w_crowbark.mdl"
SWEP.HoldType				= "melee"
if CLIENT then
	SWEP.WepSelectIcon = surface.GetTextureID("vgui/h_cbar")
	killicon.Add("kingpin_crowbar", "vgui/ah_cbar", Color( 255, 80, 0, 255))
end
function SWEP:Initialize()
	self:SetWeaponHoldType(self.HoldType)
end
function SWEP:Deploy()
	self.Weapon:SetNextPrimaryFire(CurTime() + 0.5)
	self.Weapon:SendWeaponAnim(ACT_VM_DRAW)
	return true
end

function SWEP:Holster()
	self.doubleshoot = nil
	return true
end

function SWEP:PrimaryAttackImpl()
	self.Owner:LagCompensation(true)
	local tr = util.TraceLine({
		start = self.Owner:GetShootPos(),
		endpos = self.Owner:GetShootPos() + (self.Owner:GetAimVector() * 75),
		filter = self.Owner
	})
	self.Owner:LagCompensation(false)

	if tr.Hit then
		self.Owner:FireBullets({
			Num = 1,
			Src = self.Owner:GetShootPos(),
			Dir = self.Owner:GetAimVector(),
			Spread = Vector(0, 0, 0),
			Tracer = 0,
			Force = 2.5,
			Damage = 15
		})

		if SERVER then
			if tr.HitGroup == HITGROUP_HEAD then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehithead.wav"))
			elseif tr.MatType == MAT_FLESH or tr.MatType == MAT_ALIENFLESH or tr.MatType == MAT_ANTLION then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehitbody.wav"))
			elseif tr.MatType == MAT_CONCRETE then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehitcement.wav"))
			elseif tr.MatType == MAT_DIRT then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehitgravel.wav"))
			elseif tr.MatType == MAT_WOOD then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehitwood.wav"))
			elseif tr.MatType == MAT_METAL then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehittin.wav"))
			elseif tr.MatType == MAT_TILE then
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehittile.wav"))
			else
				self.Owner:EmitSound(Sound("weapons/v_pipebar/pipehitcboard.wav"))
			end
		end
	else
		self.Weapon:EmitSound(self.Primary.Sound)
	end
end

function SWEP:PrimaryAttack()
	self.Owner:SetAnimation(PLAYER_ATTACK1)
	self.Weapon:SetNextPrimaryFire(CurTime() + self.Primary.Delay)

	self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK)
	self:PrimaryAttackImpl()

	timer.Simple(0.3, function()
		self.Weapon:SendWeaponAnim(ACT_VM_SECONDARYATTACK)
		self:PrimaryAttackImpl()
	end)
end